<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'TDCI-IT Booking System'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body class="bg-gray-100 text-gray-800 min-h-screen">
  <nav class="bg-white shadow-md p-4">
    <div class="container mx-auto flex justify-between items-center">
        <div class="flex items-center gap-3">
    <a href="<?php echo e(url('/')); ?>" class="flex items-center gap-2 text-decoration-none">
        <img src="<?php echo e(asset('images/1.png')); ?>" alt="Logo" style="height: 40px;">
        <span class="font-bold text-lg text-dark">TDCI- IT Booking System</span>
    </a>
    <?php if(auth()->guard()->check()): ?>
        <?php if (! (Auth::user()->is_admin)): ?>
            <a href="<?php echo e(url('/')); ?>" style="padding: 5px 12px;  text-decoration: none; color: black;">
                Home
            </a>
            <a href="<?php echo e(route('bookings.index')); ?>" style="padding: 5px 12px;  text-decoration: none; color: black;">
                Dashboard
            </a>
                <a href="<?php echo e(route('equipment.index')); ?>" style="padding: 5px 12px;  text-decoration: none; color: black;">
                View Equipment
            </a>
        <?php endif; ?>
    <?php endif; ?>
<?php if(auth()->guard()->check()): ?>
    <?php if(Auth::user()->is_admin): ?>
        <a href="<?php echo e(route('admin.bookings.index')); ?>"
           style="padding: 6px 12px; ; text-decoration: none; color: black;">
            View Bookings
        </a>
               <a href="<?php echo e(route('admin.dashboard')); ?>"
           style="padding: 6px 12px; ; text-decoration: none; color: black;">
           Equipments
    </a>
        <a href="<?php echo e(route('admin.bookings.trashed')); ?>"
           style="padding: 6px 12px; ; text-decoration: none; color: black;">
            Trashed Bookings
               </a>
    <?php endif; ?>
<?php endif; ?>

        </div>

            <?php if(auth()->guard()->check()): ?>
                <div>
                    Welcome, <?php echo e(Auth::user()->name); ?> |
                    <form action="<?php echo e(route('logout')); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-red-500">Logout</button>
                    </form>
                </div>
            <?php endif; ?>
        </div>
    </nav>

    <main class="container mx-auto mt-8">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
</body>
</html>
<?php /**PATH D:\James\Laravel\App\example\resources\views/layouts/app.blade.php ENDPATH**/ ?>