<?php $__env->startSection('title', 'Manage Bookings'); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="mb-4">All Bookings</h1>

    <?php
        // Custom status order
        $statusOrder = ['Pending' => 1, 'Approved' => 2, 'Returned' => 3, 'Rejected' => 4];

        // Sort by status first, then by booking date
        $bookings = $bookings->sortBy(function ($booking) use ($statusOrder) {
            return sprintf(
                '%d-%s',
                $statusOrder[$booking->status] ?? 99,
                $booking->date_of_booking
            );
        });
    ?>

    <table class="table table-bordered table-hover align-middle">
        <thead class="table-secondary">
            <tr>
                <th>User</th>
                <th>Equipment</th>
                <th>Quantity</th>
                <th>Booking Date</th>
                <th>Booking Time</th>
                <th>Return Date</th>
                <th>Return Time</th>
                <th>Location</th>
                <th>Status</th>
                <th class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($booking->user->name); ?></td>
                    <td><?php echo e($booking->equipment->name); ?></td>
                    <td><?php echo e($booking->quantity); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($booking->date_of_booking)->format('F j, Y')); ?></td>
                    <td><?php echo e($booking->booking_time ?? '-'); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($booking->date_of_return)->format('F j, Y')); ?></td>
                    <td><?php echo e($booking->return_time ?? '-'); ?></td>
                    <td><?php echo e($booking->location ?? '-'); ?></td>
                    <td>
                        <span class="badge
                            <?php if($booking->status == 'Approved'): ?> bg-success
                            <?php elseif($booking->status == 'Rejected'): ?> bg-danger
                            <?php elseif($booking->status == 'Returned'): ?> bg-primary
                            <?php else: ?> bg-secondary
                            <?php endif; ?>">
                            <?php echo e($booking->status ?? 'Pending'); ?>

                        </span>
                    </td>
                    <td class="text-center">
                      <?php if($booking->status == 'Pending' || $booking->status == 'Rejected'): ?>
    <form action="<?php echo e(route('admin.bookings.approve', $booking->id)); ?>" method="POST" class="d-inline">
        <?php echo csrf_field(); ?>
        <button class="btn btn-success btn-sm">Approve</button>
    </form>

                          <button type="button" class="btn btn-danger btn-sm"
        data-bs-toggle="modal" data-bs-target="#rejectModal"
        data-id="<?php echo e($booking->id); ?>">
    Reject
</button>
<!-- Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" id="rejectForm">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Reject Booking</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <label for="reason" class="form-label">Reason</label>
            <textarea class="form-control" name="reason" id="reason" rows="3" required></textarea>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-danger">Reject</button>
          </div>
        </div>
    </form>
  </div>
</div>
                        <?php elseif($booking->status == 'Approved'): ?>
                            <form action="<?php echo e(route('admin.bookings.return', $booking->id)); ?>" method="POST" class="d-inline"
                                  onsubmit="return confirm('Mark this equipment as returned?');">
                                <?php echo csrf_field(); ?>
                                <button class="btn btn-primary btn-sm">Mark Returned</button>
                            </form>
                        <?php endif; ?>

                        <form action="<?php echo e(route('admin.bookings.destroy', $booking->id)); ?>" method="POST" class="d-inline"
                              onsubmit="return confirm('Are you sure you want to delete this booking?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-outline-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    var rejectModal = document.getElementById('rejectModal');
    rejectModal.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var bookingId = button.getAttribute('data-id');
        var form = document.getElementById('rejectForm');
        form.action = "/admin/bookings/" + bookingId + "/reject";
    });
});
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\James\Laravel\App\example\resources\views/admin/bookings/index.blade.php ENDPATH**/ ?>