<?php $__env->startSection('content'); ?>
<div class="container mx-auto mt-6">

    
    <?php if(session('success')): ?>
        <div class="bg-green-200 text-green-800 p-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <div class="bg-white shadow-md rounded p-4">
        <h2 class="text-xl font-bold mb-4">Equipment List</h2>
        <table class="table-auto w-full border-collapse border border-gray-300">
           <thead>
    <tr>
        <th class="border p-2">ID</th>
        <th class="border p-2">Image</th> 
        <th class="border p-2">Name</th>
        <th class="border p-2">Status</th>
        <th class="border p-2">Quantity</th>
        <th class="border p-2">Actions</th>
    </tr>
</thead>
<tbody>
    <?php $__currentLoopData = $equipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td class="border p-2"><?php echo e($equipment->id); ?></td>
        <td class="border p-2">
            <?php if($equipment->image): ?>
                <img src="<?php echo e(asset($equipment->image)); ?>" alt="Equipment Image"
                     class="w-10 h-10 object-cover rounded">
            <?php else: ?>
                <span class="text-gray-500">No Image</span>
            <?php endif; ?>
        </td>
        <td class="border p-2"><?php echo e($equipment->name); ?></td>
        <td class="border p-2"><?php echo e($equipment->status); ?></td>
        <td class="border p-2"><?php echo e($equipment->quantity); ?></td>
        <td class="border p-2">
                        
                        <form action="<?php echo e(route('admin.dashboard.update', $equipment->id)); ?>" method="POST" class="inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="text" name="name" value="<?php echo e($equipment->name); ?>" class="border p-1 rounded" required>
                            <input type="text" name="status" value="<?php echo e($equipment->status); ?>" class="border p-1 rounded" required>
                            <input type="number" name="quantity" value="<?php echo e($equipment->quantity); ?>" class="border p-1 rounded w-20" min="0" required>
                            <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded">Update</button>
                        </form>

                        
                        <form action="<?php echo e(route('admin.dashboard.destroy', $equipment->id)); ?>" method="POST" class="inline-block ml-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded"
                                onclick="return confirm('Are you sure you want to delete this equipment?')">
                                Delete
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    
    <div class="bg-white shadow-md rounded p-4 mt-6">
        <h2 class="text-xl font-bold mb-4">Add New Equipment</h2>
  <form action="<?php echo e(route('admin.dashboard.store')); ?>"
      method="POST"
      enctype="multipart/form-data"  
      class="space-y-3">
    <?php echo csrf_field(); ?>
    <div>
        <label class="block">Name:</label>
        <input type="text" name="name" class="border p-2 rounded w-full" required>
    </div>
    <div>
        <label class="block">Status:</label>
        <input type="text" name="status" class="border p-2 rounded w-full" required>
    </div>
    <div>
        <label class="block">Quantity:</label>
        <input type="number" name="quantity" class="border p-2 rounded w-full" min="0" required>
    </div>
    <div>
        <label for="image">Upload Image</label>
        <input type="file" name="image" id="image" class="border p-2 w-full">
    </div>
    <div>
        <button type="submit" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded">
            Add Equipment
        </button>
    </div>
</form>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\James\Laravel\App\example\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>