<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4">
    <h1 class="text-2xl font-bold mb-6">Available Equipments</h1>

    <?php if($equipments->count() > 0): ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            <?php $__currentLoopData = $equipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $equipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white shadow-md rounded-lg p-5 border border-gray-200 text-center">

                    
                    <?php if($equipment->image): ?>
                        <img src="<?php echo e(asset($equipment->image)); ?>"
                             alt="<?php echo e($equipment->name); ?>"
                             class="h-12 w-full object-cover rounded mb-3">
                    <?php else: ?>
                        <div class="h-30 w-full bg-gray-200 flex items-center justify-center rounded mb-3">
                            <span class="text-gray-500">No Image</span>
                        </div>
                    <?php endif; ?>

                    
                    <h2 class="text-xl font-semibold mb-2"><?php echo e($equipment->name); ?></h2>
                    <p class="mb-1"><strong>Quantity:</strong> <?php echo e($equipment->quantity); ?></p>
                    <p class="mb-3"><strong>Status:</strong>
                        <span class="<?php echo e($equipment->status === 'Available' ? 'text-green-600' : 'text-red-600'); ?>">
                            <?php echo e($equipment->status); ?>

                        </span>
                    </p>

                    
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('bookings.create', $equipment->id )); ?>"
                           class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                            Book Now
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>"
                           class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                            Book Now
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <p class="text-gray-600">No equipment available.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\James\Laravel\App\example\resources\views/equipments/index.blade.php ENDPATH**/ ?>